#ifndef PARSER_ATP_CRYS_SST_SYM_H
#define PARSER_ATP_CRYS_SST_SYM_H


#include "msg_defs.h"
#include "SST_SEP_TST.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_CRYS_SST_HMAC     
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application 
* of connection between CRYS and the SSTfunctionality while using SST HMAC generated keys
* in the CRYS_SST module
* It calls the SEP function with parameters parsed from input message.
*
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_PARSER_CRYS_SST_HMAC(DxUint32_t* msg);
/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_CRYS_SST_DES     
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application 
* of connection between CRYS and the SSTfunctionality while using SST HMAC generated keys
* in the CRYS_SST module
* It calls the SEP function with parameters parsed from input message.
*
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_PARSER_CRYS_SST_DES(DxUint32_t* msg);

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_CRYS_SST_AES     
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application 
* of connection between CRYS and the SSTfunctionality while using SST HMAC generated keys
* in the CRYS_SST module
* It calls the SEP function with parameters parsed from input message.
*
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_PARSER_CRYS_SST_AES(DxUint32_t* msg);
#endif
